/*:
 * @target MZ
 * @plugindesc 変数の値に応じてピクチャを自動切替するプラグイン
 * @author 
 *
 * @command StartPictureSwitch
 * @text ピクチャ切替開始
 * @desc 変数の監視を開始し、範囲に応じてピクチャを切り替える
 *
 * @arg pictureId
 * @text ピクチャ番号
 * @type number
 * @min 1
 * @default 1
 *
 * @arg variableId
 * @text 監視する変数番号
 * @type variable
 * @default 1
 *
 * @arg ranges
 * @text 範囲設定
 * @type struct<Range>[]
 * @desc 変数の値の範囲と対応する画像を設定
 *
 * @command StopPictureSwitch
 * @text ピクチャ切替停止
 * @desc 指定したピクチャ番号の監視を停止する
 *
 * @arg pictureId
 * @text ピクチャ番号
 * @type number
 * @min 1
 */

/*~struct~Range:
 * @param min
 * @text 最小値
 * @type number
 *
 * @param max
 * @text 最大値
 * @type number
 *
 * @param filename
 * @text ピクチャファイル
 * @type file
 * @dir img/pictures
 */

(() => {
    const pluginName = "VariablePictureSwitch";

    let watchers = [];

    // プラグインコマンド登録
    PluginManager.registerCommand(pluginName, "StartPictureSwitch", args => {
        const pictureId = Number(args.pictureId);
        const variableId = Number(args.variableId);
        const ranges = JSON.parse(args.ranges).map(r => JSON.parse(r));

        watchers = watchers.filter(w => w.pictureId !== pictureId); // 重複防止
        watchers.push({ pictureId, variableId, ranges });
    });

    PluginManager.registerCommand(pluginName, "StopPictureSwitch", args => {
        const pictureId = Number(args.pictureId);
        watchers = watchers.filter(w => w.pictureId !== pictureId);
    });

    // 更新処理
    const _Spriteset_Base_update = Spriteset_Base.prototype.update;
    Spriteset_Base.prototype.update = function() {
        _Spriteset_Base_update.call(this);
        if (watchers.length > 0) {
            watchers.forEach(w => {
                const value = $gameVariables.value(w.variableId);
                const sprite = this._pictureContainer.children.find(
                    s => s.pictureId && s.pictureId() === w.pictureId
                );
                if (sprite) {
                    for (const range of w.ranges) {
                        const min = Number(range.min);
                        const max = Number(range.max);
                        if (value >= min && value <= max) {
                            if (sprite.bitmap && sprite.bitmap.url !== `img/pictures/${range.filename}.png`) {
                                sprite.bitmap = ImageManager.loadPicture(range.filename);
                            }
                        }
                    }
                }
            });
        }
    };
})();
